#include "stdafx.h"
#include "LF C DEMO.h"
#include "DlgGeneralInfo.h"

#include "LF_ID_C_API.h"
#include "Utility.h"

IMPLEMENT_DYNAMIC(CDlgGeneralInfo, CPropertyPage)

CDlgGeneralInfo::CDlgGeneralInfo()
	: CPropertyPage(CDlgGeneralInfo::IDD)
{
}

CDlgGeneralInfo::~CDlgGeneralInfo()
{
}

void CDlgGeneralInfo::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_SERIAL_NR, m_ctrlSerialNr);
	DDX_Control(pDX, IDC_EDIT_VERSION, m_ctrlVersion);
}


BEGIN_MESSAGE_MAP(CDlgGeneralInfo, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_RESET, &CDlgGeneralInfo::OnBnClickedBtnReset)
	ON_BN_CLICKED(IDC_BTN_INFO, &CDlgGeneralInfo::OnBnClickedBtnInfo)
	ON_BN_CLICKED(IDC_BTN_LED, &CDlgGeneralInfo::OnBnClickedBtnLed)
END_MESSAGE_MAP()



void CDlgGeneralInfo::OnBnClickedBtnReset()
{
	SDKHANDLE hReader = OpenReader(m_rfidDriver.ComPort());
	if(hReader != NULL)
	{
		ResetReader(hReader);

		CloseReader(hReader);
	}

}

void CDlgGeneralInfo::OnBnClickedBtnInfo()
{
	SDKHANDLE hReader = OpenReader(m_rfidDriver.ComPort());
	if(hReader != NULL)
	{
		BYTE pBufTmp[MAX_PATH]; UINT nSize = MAX_PATH;
		if(GetReaderVersion(hReader, pBufTmp, nSize) == ER_OK)
		{
			USES_CONVERSION;
			m_ctrlVersion.SetWindowText(A2T((CHAR*)pBufTmp));
		}

		ZeroMemory(pBufTmp, MAX_PATH); nSize = MAX_PATH;
		if(GetSerialNumber(hReader, pBufTmp, nSize) == ER_OK)
		{
			m_ctrlSerialNr.SetWindowText(CUtility::DataToString(pBufTmp, nSize, FALSE));
		}

		CloseReader(hReader);
	}	
}

void CDlgGeneralInfo::OnBnClickedBtnLed()
{
	SDKHANDLE hReader = OpenReader(m_rfidDriver.ComPort());
	if(hReader != NULL)
	{
		SetReaderLed(hReader, 0x02);
		Sleep(1000);
		SetReaderLed(hReader, 0x01);
		Sleep(1000);
		SetReaderLed(hReader, 0x00);

		BYTE bData = 0x00;
		ReadEPROM(hReader, 0x00, bData);

		CloseReader(hReader);
	}
}
